/*----------------------------------------------------------------------------
 * Name     : main.c
 * Purpose  : BC3602 test 
 * Note(s)  : 
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#include    <stdio.h>
#include    <string.h>
#include    "main.h"
 
const char main_menu_FIFO_string[][17] = 			
{
		"TX_Carry_Mode"			
};

const char main_menu_TRX_string[][13] = 
{	
		">>TX_Carry"
};

u8 		TxPayloadData[64];
u8 		RxPayloadData[64];
bool 	button_change;
u8		button_state;
u16   time_period;
u8 		StartFlag = 0;
u8 		irq_state = 0;
u8 		operate_item = 0;
u32		tx_packet_time,rx_packet_time;
u32		TX_packet_counter,RX_packet_counter,RX_packet_counterS,Error_counter;
s8    lcm_buffer[22];

USART_InitTypeDef USART_InitStructure;

/*----------------------------------------------------------------------------
  Main Program
 *----------------------------------------------------------------------------*/
int main (void)
{	
	/* -------------- Demo Board Peripheral initial ------------------------------------ */
	CKCU_Configuration();
	MCU_gpio_Configuration();
	BFTM0_configure();
	button_IO_configure();   
	LED_IO_configure();	
	BCE_GENTrx32_Board_UART_Init();
	/* -------------- BC3602 initial --------------------------------- */
  BC3602_Initial();
  /* -------------- LCM initial ------------------------------------ */
	LCM_Init();
	/*  ---------------------------------------------------------------*/
	
  while(1)
  {	
		URAT_TimerCounter();
		Analysis_Command();		
		LED_flash_process();		
		if(timer_operate.bits.t1ms)
		{
			LEDProcess_ms();
			timer_operate.bits.t1ms = FALSE;
			button_change = scan_button_IO();
      if(time_period) time_period--;
    }
    if(button_change)
    {
			button_change = FALSE;
			button_state = load_button_IO();	
			if(button_state == BUTTON2_State)
			{	
				StartFlag = !StartFlag;
				if(StartFlag)
					BC3602_LightSleepMode();
				else
					goto_default_mode();
			}
    }	
		if(!RF_IRQ_IN)
		{
			irq_state = BC3602_GetIrqState();
			BC3602_ClearIrqFlag(irq_state);
		}	
/* -------------- TX_MODE	 ------------------------------------ */

		sprintf((char *)lcm_buffer,"Tx Carrier      ");
		lcm_put8x8_string((s8 *)lcm_buffer,4,0,DSP_NORMAL);
		operate_item = 0;
		   
/*****************************************************************************************************
* @brief  tx carrier mode process.
* @retval None
*******************************************************************************************************/
		
		if(StartFlag) 
		{
			switch(operate_item)
			{
				case 0:
					BC3602_WriteRegister(CONFIG_REGS,BC3602_ReadRegister(CONFIG_REGS) | 0x10);		//enable direct mode
					BC3602_StrobeCommand(REGS_BANK_CMD+REGS_BANK1);   
					BC3602_WriteRegister(FILTER_CTL2_REGS, 0x00); 		//FSCALE[11:0]=0 for fDeviation=0
					BC3602_StrobeCommand(REGS_BANK_CMD+REGS_BANK0);
					if(time_period == 0)
					{
						LED_EnableFlag_ms(1,50);
						time_period = 50;
					}				
					BC3602_EnableDirTx();
					operate_item++;
				break;
					
				case 1:
				
        break;
			}	
		}
		else
		{
			BC3602_DisableDir();
			LED1_OFF;
		}
		
	}   
}

/*****************************************************************************************************
* @brief  let TRBCLK output in fifo mode.
* @retval None
*******************************************************************************************************/
void let_TRBCLK_output_in_fifo(u8 trx_sel)
{
	u8	x;
	x = BC3602_ReadRegister(OPERATION_CTL_REGS);			//b2=RTX_EN, b1=RTX_SEL, b0=SX_EN
	if(trx_sel==_OM_RX_)
		x &= ~0x02;															
	else
		x |= 0x02;
	BC3602_WriteRegister(OPERATION_CTL_REGS, x);		
}


/*****************************************************************************************************
* @brief  Configures the system clocks.
* @retval None
*******************************************************************************************************/
void MCU_gpio_Configuration(void)
{
	HT_AFIO->GPCCFGR[0] &= ~((3UL << (_GPIO3_ * 2)) | (3UL << (_GPIO4_ * 2)));  
  HT_GPIOA->DIRCR |= (GPIO3P | GPIO4P );          	/* output mode */   
  HT_GPIOA->INER |= (GPIO3P | GPIO4P);             	/* input enable */
  HT_GPIOA->PUR |= (GPIO3P | GPIO4P);              	/* pull-high enable */  
	HT_GPIOA->DOUTR |= (GPIO3P | GPIO4P); 
}

/*******************************************************************************************************
 * @brief  Configures the system clocks.
 * @retval None
 *******************************************************************************************************/
void CKCU_Configuration(void)
{
	CKCU_PeripClockConfig_TypeDef cken = {{ 0 }};
  
   /* APB Peripheral Clock Selection to CK_AHB or CK_AHB/4 */
  HT_CKCU->APBPCSR0 = 0;           /* Reset value of APBPCSR0   */
  HT_CKCU->APBPCSR1 = 0;           /* Reset value of APBPCSR1   */ 

  /* Configure the CK_ADC prescaler(CK_ADC) = HCLK / 1 */
  CKCU_SetADCPrescaler(CKCU_ADCPRE_DIV1);   
/*
//  <h> Communication
//    <q3> EBI
//    <q9> I2C0   <q10> I2C1
//    <q21> I2S
//    <q19> SCI0 <q20> SCI1
//    <q11> SPI0   <q12> SPI1
//    <q15> UART0  <q16> UART1
//    <q13> USART0 <q14> USART1
//    <q1>  USB
//  </h>
//  <h> IO
//    <q5> GPIO Port A <q6>  GPIO Port B <q7>  GPIO Port C <q8>  GPIO Port D
//    <q17> AFIO
//    <q18> EXTI
//  </h>
//  <h> System
//    <q30> ADC
//    <q2>  CKREF
//    <q4>  CRC
//    <q29> CMP
//    <q0>  PDMA
//    <q24> PWRCU
//  </h>
//  <h> Timer
//    <q27> BFTM0 <q28> BFTM1
//    <q31> SCTM0 <q32> SCTM1 <q33> SCTM2 <q34> SCTM3
//    <q25> GPTM0 <q26> GPTM1
//    <q22> MCTM0
//    <q24> RTC   <q23> WDT
//  </h>
*/
	cken.Bit.PDMA       = 1;
	cken.Bit.USBD       = 0;
	cken.Bit.CKREF      = 1;
	cken.Bit.EBI        = 0;
	cken.Bit.CRC        = 1;
	cken.Bit.PA         = 1;
	cken.Bit.PB         = 1;
	cken.Bit.PC         = 1;
	cken.Bit.PD         = 1;
	cken.Bit.I2C0       = 1;
	cken.Bit.I2C1       = 1;
	cken.Bit.SPI0       = 1;
	cken.Bit.SPI1       = 1;
	cken.Bit.USART0     = 1;
	cken.Bit.USART1     = 1;
	cken.Bit.UART0      = 1;
	cken.Bit.UART1      = 1;
	cken.Bit.AFIO       = 1;
	cken.Bit.EXTI       = 1;
	cken.Bit.SCI0       = 1;
	cken.Bit.SCI1       = 0;
	cken.Bit.I2S        = 0;
	cken.Bit.MCTM0      = 1;
	cken.Bit.WDT        = 0;
	cken.Bit.BKP        = 1;
	cken.Bit.GPTM0      = 1;
	cken.Bit.GPTM1      = 1;
	cken.Bit.BFTM0      = 1;
	cken.Bit.BFTM1      = 1;
	cken.Bit.CMP        = 1;
	cken.Bit.ADC        = 1;
	cken.Bit.SCTM0      = 1;
	cken.Bit.SCTM1      = 1;
	cken.Bit.SCTM2      = 1;
	cken.Bit.SCTM3      = 1;	  
  CKCU_PeripClockConfig(cken,ENABLE);   
}

/************************************************************************************************************
 * @brief Configures UART Interrupt.
 * @retval None
 ************************************************************************************************************/
void BCE_GENTrx32_Board_UART_Init(void)
{
	CKCU_PeripClockConfig_TypeDef CKCUClock = {{0}};
  USART_InitTypeDef USART_InitStructure;

  /* Enable peripheral clock of AFIO, USART0                                                                */
  CKCUClock.Bit.AFIO       = 1;
  COM1_CLK(CKCUClock)      = 1;
  CKCU_PeripClockConfig(CKCUClock, ENABLE);

  /* Config AFIO mode as COM1_Rx and COM1_Tx function.                                                      */
  AFIO_GPxConfig(COM1_TX_GPIO_ID, COM1_TX_AFIO_PIN, AFIO_FUN_USART_UART);
  AFIO_GPxConfig(COM1_RX_GPIO_ID, COM1_RX_AFIO_PIN, AFIO_FUN_USART_UART);

  /* COM1 configuration ------------------------------------------------------------------------------------*/
  /* COM1 configured as follow:
        - BaudRate = 115200 baud
        - Word Length = 8 Bits
        - One Stop Bit
        - None parity bit
  */
  USART_InitStructure.USART_BaudRate = 115200;
  USART_InitStructure.USART_WordLength = USART_WORDLENGTH_8B;
  USART_InitStructure.USART_StopBits = USART_STOPBITS_1;
  USART_InitStructure.USART_Parity = USART_PARITY_NO;
  USART_InitStructure.USART_Mode = USART_MODE_NORMAL;
  USART_Init(COM1_PORT  , &USART_InitStructure);

  /* Seting COM1_PORT interrupt-flag                                                                        */
  USART_IntConfig(COM1_PORT, USART_INT_RXDR, ENABLE);
  /* Enable COM1_PORT                                                                                       */
  USART_TxCmd(COM1_PORT, ENABLE);
  USART_RxCmd(COM1_PORT, ENABLE);
  /* Configure USART0 & USART1 interrupt                                                                    */
  NVIC_EnableIRQ(COM1_IRQn);

  /* COM1 Tx                                                                                                 */
	
	sprintf((char *)URTxBuf,"Hello, This is BEC-GENTrx32-001 Development Board for BCM-3602-X02 Demo Code. Please enter command to request Data...");				
	UART_SendData((char*)&URTxBuf, sizeof(URTxBuf));
	memset(URTxBuf, 0, sizeof(URTxBuf));
	UART_SendNEWLine();
}

/************************************************************************************************************
 * @brief Show LCM Init.
 * @retval None
 ************************************************************************************************************/
void LCM_Init(void)
{
	lcm_bus_configure();
	lcm_configure();
	lcm_put_map((u8 *)BestComm_Logo);
	lcm_put8x16_string((sc8 *)"BC3602",0, 9,DSP_NORMAL);
	lcm_put8x16_string((sc8 *)"TXCarry",1,10,DSP_NORMAL);
	lcm_put8x8_string((sc8 *)"V130  ",4,12,DSP_NORMAL);
	lcm_put8x8_string((sc8 *)"22/01/19",5,8,DSP_NORMAL);
	
	delay_ms(1500);
	lcm_clear();
	lcm_put8x8_string((s8 *)main_menu_FIFO_string,0,0,DSP_NORMAL);
	lcm_put8x8_string((s8 *)main_menu_TRX_string,1,4,DSP_NORMAL); 
}
